//=============================================================================
// EnemyDamegeOffset_RevisionTag.js
// ----------------------------------------------------------------------------
// (C)2022 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2023/11/05 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc エネミーダメージポップアップ座標補正タグ
 * @target MZ
 * @author くろあめ
 *
 * @help
 * エネミーのダメージポップアップ位置を補正するタグを導入します。
 *
 * エネミーのメモ欄に
 * <DamPopRevisionX:nnn>と記載することで 
 * そのエネミーのダメージポップアップの位置は横にnnnピクセル分ズレます（元位置からの相対位置です）
 *
 * エネミーのメモ欄に
 * <DamPopRevisionY:nnn>と記載することで 
 * そのエネミーのダメージポップアップの位置は縦にnnnピクセル分ズレます（元位置からの相対位置です）
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
 */

(function() {

// KURO 3D演出OFF対応
const params_mpp_3dbt = PluginManager.parameters('MPP_Pseudo3DBattle');
const param_3dEffectOffSwitch = Number(params_mpp_3dbt['3D Effect Off Switch'] || 0);

const _Sprite_Enemy_damageOffsetX_kuro = Sprite_Enemy.prototype.damageOffsetX;
Sprite_Enemy.prototype.damageOffsetX = function() {
  if (this._enemy && this._enemy.enemy().meta && this._enemy.enemy().meta.DamPopRevisionX){
      return _Sprite_Enemy_damageOffsetX_kuro.call(this) + Number(this._enemy.enemy().meta.DamPopRevisionX);
  }
  return _Sprite_Enemy_damageOffsetX_kuro.call(this);
};

const _Sprite_Enemy_damageOffsetY_kuro = Sprite_Enemy.prototype.damageOffsetY;
Sprite_Enemy.prototype.damageOffsetY = function() {
  if (this._enemy && this._enemy.enemy().meta && this._enemy.enemy().meta.DamPopRevisionY){
      var Yplus = 0;
      if($gameSwitches.value(param_3dEffectOffSwitch)){
          Yplus = -90;
      }
      return _Sprite_Enemy_damageOffsetY_kuro.call(this) + Number(this._enemy.enemy().meta.DamPopRevisionY) + Yplus;
  }
  return _Sprite_Enemy_damageOffsetY_kuro.call(this);
};

})();
